import tkinter as tk

def update_label():
    entry_string = var.get()
    temp_fahrenheit = float(entry_string)
    temp_celsius = (temp_fahrenheit - 32)*5/9
    message = round(temp_celsius,1)
    lbl_3.configure(text=message)
   
    return

root = tk.Tk()
root.title('Fahrenheit to Celsius Converter')
root.geometry('300x140')

frame = tk.Frame(root, bg='blue', bd=2)
frame.pack(padx=0,pady=4)

lbl_1 = tk.Label(frame,text='Enter Fahrenheit Temperature:')
var = tk.StringVar()
ent = tk.Entry(frame,textvariable=var, justify=tk.CENTER)
lbl_2 = tk.Label(frame,text='Equivalent Celsius Temperature:')
lbl_3 = tk.Label(frame, text=' ', width=20, bg='white')
btn = tk.Button(root,text='Convert',command=update_label)

lbl_1.pack(fill=tk.X)
ent.pack(fill=tk.X)
lbl_2.pack(fill=tk.X)
lbl_3.pack(fill=tk.X)
btn.pack()

root.mainloop()

